'*******************************************************************************
' CAM_routines
'*******************************************************************************
' V1.0
' six1 01/2010  (Michael Kcher)
'*******************************************************************************
' Cam Modul C328R
' ONLY FOR 3.3V usage!!!
' HCT4050 for converting tx/rx
' optimized for SOFTWARE UART USAGE! ;-)
'*******************************************************************************
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'
'*******************************************************************************
$nocompile

' you need (for executing this code without changes!):
'  - net-io board from pollin.de
'  - sd-card connected to spi (ISP connector) and /CS PortB.1
'  - Cam Modul C328R  (i.e. http://www.sander-electronic.de/gm00021.html )
'    connected to txd: PortC.0, rxd: PortC.1
'    CAM IS AT 3,3V!!!  HCT4050 and 3,3V Regulator, or connect 3,3V from NET-IO to SUBD25 (PIN14)
'

' usage of cam class:
'
' 'Cam_res_160x128
' 'Cam_res_320x240
' 'Cam_res_640x480
'
'    If Cam_init_picture(Cam_res_320x240) = 1 Then
'      Call Cam_get_snapshot(Cam_picturename)
'    endif

' Settings:
' have a look at cam_declarations.inc, AVR-DOS_declaration.inc

' this code has been extremly optimized for usage for software uart with 115200Bd
' by loging serial communication!
' changes may result in dysfunction!
'
'**********************************************
'* Keep out of reach of children :-) six1/2010*
'**********************************************


'-------------------------------------------------------------------------------
' Cam_compute
'   wird jede Sekunde vom Hauptprogramm aufgerufen
'-------------------------------------------------------------------------------
Sub Cam_compute
              ' mur, wenn nix im fifo!!!
               If Http_stack_flag = 0 Then
                   Incr Cam_process_pic_time_counter
                   If Cam_process_pic_time_counter >= Cam_process_pic_time Then
                      Call Activate_sdcard
                      Cam_process_pic_time_counter = 0
                      Cam_picturename = "net-io.jpg"
                      If Cam_init_picture(cam_res_320x240) = 1 Then
                        If Cam_get_snapshot(cam_picturename) = 0 Then
                           Cam_process_pic_time_counter = Cam_process_pic_time
                        End If
                        'Wend
                      End If
                      Call Activate_enc28j60
                  End If
              End If
End Sub


'-------------------------------------------------------------------------------
' Cam_init
'   First Setup
'-------------------------------------------------------------------------------
Sub Cam_initialize
  #if System_message = 1 : Print "-> CAM INIT..." ; : #endif
  'init cam first time, during program executing, you can change resolution too!
'  If Cam_init_picture(cam_res_160x128) = 1 Then
  If Cam_init_picture(cam_res_320x240) = 1 Then
'  If Cam_init_picture(cam_res_640x480) = 1 Then
     #if System_message = 1 : Print "ok" : #endif
  Else
     #if System_message = 1 : Print "failed" : #endif
  End If
  ' first time wait 1-2 sec for stabilizing avg and white balance
  Wait 1
  'try until we got a Picture
  Cam_picturename = "net-io.jpg"
  If Cam_get_snapshot(cam_picturename) = 0 Then
     Cam_process_pic_time_counter = Cam_process_pic_time
  End If
End Sub

'-------------------------------------------------------------------------------
' Cam_syn
'   up to 60 retries for get Cam's attention!
'-------------------------------------------------------------------------------
Function Cam_syn() As Byte
 Local Btrys As Byte
   Call Cam_reset
   $timeout = 100000
   Cam_syn = 0
   For Btrys = 1 To 60
      If Cam_send_command2(&Haa , &H0D , &H00 , &H00 , &H00 , &H00 , &H0E , &H0D) = 1 Then
         Call Cam_receive_command
         If Cam_command_1 = &H0D And Cam_command_2 = &H00 Then       'SYN from Cam
           Call Cam_send_command(&Haa , &H0E , &H0D , &H00 , &H00 , &H00)
           Cam_syn = 1
           #if Debug_cam = 1
           Print "  SYN ok"
           #endif
           Exit For
        End If
      End If
      Waitms 5
      Reset Watchdog
   Next
   Waitms 100
End Function

'-------------------------------------------------------------------------------
'  Cam_init_picture
'    setup picture, resolution before capture picture!
'-------------------------------------------------------------------------------
Function Cam_init_picture(byval Pic_size As Byte) As Byte
  Local Cam_framesize_low As Byte
  Local Cam_framesize_high As Byte
     Cam_framesize_low = Low(cam_framesize)
     Cam_framesize_high = High(cam_framesize)
     Cam_init_picture = 0
     If Cam_syn() = 1 Then
     ' setup baudrate  (not necessary... cam did auto baud!)
'     If Cam_send_command2(&Haa , &H07 , &H0F , &H01 , &H00 , &H00 , &H0E , &H07) = 1 Then
        ' initial: color type, resolution, jpeg resolution
        If Cam_send_command2(&Haa , &H01 , &H00 , &H07 , &H03 , Pic_size , &H0E , &H01) = 1 Then
          ' setup package size
          If Cam_send_command2(&Haa , &H06 , &H08 , Cam_framesize_low , Cam_framesize_high , &H00 , &H0E , &H06) = 1 Then
            ' light frequency filter (50Hz / 60 Hz)
            If Cam_send_command2(&Haa , &H13 , Cam_light_frequency_type , &H00 , &H00 , &H00 , &H0E , &H13) = 1 Then
              Cam_init_picture = 1
              #if Debug_cam = 1
              Print "  setup cam ok"
              #endif
            End If
          End If
        End If
'     End If
     End If
End Function


'-------------------------------------------------------------------------------
' Cam_send_command2( 6 Byte, result 2 byte)
'  getting cams attention on command!
'  the cam sometimes didn't respond on first sending of command,
'  so we try it several times... (little tricky but works fine :-)
'-------------------------------------------------------------------------------
Function Cam_send_command2(byval Cam_b1 As Byte , Byval Cam_b2 As Byte , Byval Cam_b3 As Byte , Byval Cam_b4 As Byte , Byval Cam_b5 As Byte , Byval Cam_b6 As Byte , Byval Res1 As Byte , Byval Res2 As Byte ) As Byte
 Local Btrys As Byte
   Cam_send_command2 = 0
   $timeout = 20000
   For Btrys = 1 To 10
      Cam_command_1 = 0
      Cam_command_2 = 0
      Call Cam_send_command(cam_b1 , Cam_b2 , Cam_b3 , Cam_b4 , Cam_b5 , Cam_b6)
      Call Cam_receive_command
      If Cam_command_1 = Res1 And Cam_command_2 = Res2 Then
         Cam_send_command2 = 1
         Exit For
      End If
   Next
End Function

'-------------------------------------------------------------------------------
' Cam_send_command( 6 Byte)
'-------------------------------------------------------------------------------
Sub Cam_send_command(byval Cam_b1 As Byte , Byval Cam_b2 As Byte , Byval Cam_b3 As Byte , Byval Cam_b4 As Byte , Byval Cam_b5 As Byte , Byval Cam_b6 As Byte )
    Printbin #10 , Cam_b1
    Printbin #10 , Cam_b2
    Printbin #10 , Cam_b3
    Printbin #10 , Cam_b4
    Printbin #10 , Cam_b5
    Printbin #10 , Cam_b6
End Sub


'-------------------------------------------------------------------------------
' Cam_receive_command( 6 Byte)
'-------------------------------------------------------------------------------
Sub Cam_receive_command
      Cam_command_1 = 0
      Cam_command_2 = 0
      Inputbin #11 , Cam_command_inbuf(1) , 6
End Sub

'-------------------------------------------------------------------------------
' Cam_receive_header( 6 Byte)
'-------------------------------------------------------------------------------
Sub Cam_receive_header
     $timeout = &HFFFFFFFF
     Inputbin #11 , Cam_pic_header(1) , 6
End Sub

'-------------------------------------------------------------------------------
' Cam_reset
'-------------------------------------------------------------------------------
Sub Cam_reset()
    Call Cam_send_command(&Haa , &H08 , &H01 , &H00 , &H00 , &H00 )
    Waitms 30
End Sub


'-------------------------------------------------------------------------------
' Cam_get_snapshot( Filename)
'-------------------------------------------------------------------------------
Function Cam_get_snapshot(byref Cam_picturename As String)as Byte
  Local Rx_byte As Long
  Local Pic_size As Long
  Local Segment_size As Word
  Local Rx_paket As Word
  Local Lsb As Byte , Msb As Byte
  Local Timeoff As Word
  Local Read_rx1 As Byte , Read_rx2 As Byte
  Local Inchar As Byte
  Local Xx As Byte

  Cam_get_snapshot = 1
   Kill Cam_picturename
   Open Cam_picturename For Binary As #20
   If Gbdoserror > 0 Then
      #if Debug_cam = 1
      Print "DOS Error: " ; Gbdoserror
      #endif
   Else
     If Cam_syn() = 1 Then
      ' get snapshot compressed picture
       If Cam_send_command2(&Haa , &H05 , &H00 , &H00 , &H00 , &H00 , &H0E , &H05 ) = 1 Then
         ' Request snapshot data header
         Waitms 10
         Call Cam_send_command(&Haa , &H04 , Cam_pic_type_snapshot , &H00 , &H00 , &H00 )
         Call Cam_receive_command
            ' don't know, when the shit is starting... :-)
            Rx_paket = 0
            Cam_header = 0
            While Cam_header <> &H0A And Rx_paket < 1000
               Call Cam_receive_header
               Incr Rx_paket
            Wend
            If Cam_command_1 = &H0E And Cam_command_2 = &H04 Then
                 'next data with header
                 If Cam_header = &H0A Then
                     Pic_size = Cam_pic_len3
                     Shift Pic_size , Left , 8
                     Pic_size = Pic_size + Cam_pic_len2
                     Shift Pic_size , Left , 8
                     Pic_size = Pic_size + Cam_pic_len1
                     #if Debug_cam = 1
                     Print "-> RX Pic Type: " ; Cam_pic_type ; " len: " ; Str(pic_size) ; " Byte"
                     #endif
                     Rx_byte = 0
                     Rx_paket = 0
                     Disable Interrupts
                     While Rx_byte < Pic_size
                          Lsb = Low(rx_paket )
                          Msb = High(rx_paket )
                          Call Cam_send_command(&Haa , &H0E , &H00 , &H00 , Lsb , Msb )
                          $timeout = 50000
                          Inputbin #11 , Cam_command_inbuf(1) , 4
                          Reset Watchdog
                          Segment_size = Cam_command_inbuf(4)
                          Shift Segment_size , Left , 8
                          Segment_size = Segment_size + Cam_command_inbuf(3)
                          #if Cam_payload > 255
                             Read_rx1 = 255
                             Read_rx2 = Segment_size - 255
                          #else
                             Read_rx1 = Segment_size
                             Read_rx2 = 0
                          #endif
                          Inputbin #11 , Cam_picture_inbuf(1) , Read_rx1
                          #if Cam_payload > 255
                             Inputbin #11 , Cam_picture_inbuf(256) , Read_rx2
                          #endif
                          Inputbin #11 , Cam_command_inbuf(1) , 2       ' Skip CRC
                          Rx_byte = Rx_byte + Segment_size
                          Put #20 , Cam_picture_inbuf(1) , , Segment_size
                          Incr Rx_paket
                          #if Debug_cam = 1
                          Print "-> Paket: " ; Rx_paket ; " rx: " ; Str(rx_byte) ; " Segment: " ; Segment_size
                          #endif
                          If Rx_byte >= Pic_size Then
                               Call Cam_send_command(&Haa , &H0E , &H00 , &H00 , &HF0 , &HF0 )
                               Flush #20
                               #if Debug_cam = 2
                               Print "-> Picture " ; Cam_picturename ; " saved " ; Rx_byte ; " Byte ";
                               Print Time$
                               #endif
                          End If
                     Wend
                     Enable Interrupts
                 End If
             End If
          End If
     End If
   End If
   Close #20
   If Rx_byte <> Pic_size Then
      #if Debug_cam = 2
      Print "  Picture failed"
      #endif
      Kill Cam_picturename
      Cam_get_snapshot = 0
   End If
End Function


'-------------------------------------------------------------------------------
' Cam_get_motion
'    jpeg in series (not ready in time; have to figure out some things!)
'-------------------------------------------------------------------------------
Sub Cam_get_motion
  Local Rx_byte As Long
  Local Pic_size As Long
  Local Segment_size As Word
  Local Rx_paket As Word
  Local Lsb As Byte , Msb As Byte
  Local Tx As Word
  Local Read_rx As Word
  Local Inchar As Byte
  Local Xx As Byte
     If Cam_syn() = 1 Then
      ' get snapshot compressed picture
       If Cam_send_command2(&Haa , &H05 , &H00 , &H00 , &H00 , &H00 , &H0E , &H05 ) = 1 Then
            ' Request snapshot data header
            Waitms 5
Nextpicture:
            Print "PICTURESTART"
            Call Cam_send_command(&Haa , &H04 , Cam_pic_type_jpegpreview , &H00 , &H00 , &H00 )
            Call Cam_receive_command
            ' don't know, when the shit is starting... :-)
            Rx_paket = 0
            While Cam_header <> &H0A And Rx_paket < 1000
               Call Cam_receive_header
               Incr Rx_paket
            Wend
            If Cam_command_1 = &H0E And Cam_command_2 = &H04 Then
                 'next data with header
                 If Cam_header = &H0A Then                  'Header Type and Length from pic
                     Waitms 10
                     Pic_size = Cam_pic_len3
                     Shift Pic_size , Left , 8
                     Pic_size = Pic_size + Cam_pic_len2
                     Shift Pic_size , Left , 8
                     Pic_size = Pic_size + Cam_pic_len1
                     Rx_byte = 0
                     Rx_paket = 0
                     Print "SIZE:" ; Pic_size ; "///"
                     While Rx_byte < Pic_size
                          Reset Watchdog
                          Lsb = Low(rx_paket )
                          Msb = High(rx_paket )
                          Call Cam_send_command(&Haa , &H0E , &H00 , &H00 , Lsb , Msb )
                          Inputbin #11 , Cam_command_inbuf(1) , 4
                          Segment_size = Cam_command_inbuf(3)
                          Read_rx = Segment_size
                          For Xx = 1 To Read_rx
                             Inputbin #11 , Inchar
                             Cam_picture_inbuf(xx) = Inchar
                          Next
'                          Inputbin #11 , Cam_picture_inbuf(1) , Read_rx
                          Inputbin #11 , Cam_command_inbuf(1) , 2       ' Skip CRC
                          Rx_byte = Rx_byte + Segment_size
                          For Tx = 1 To Cam_command_inbuf(3)
                             Printbin Cam_picture_inbuf(tx);
                          Next
                          Incr Rx_paket
                          If Rx_byte >= Pic_size Then       ' data ready
                               Call Cam_send_command(&Haa , &H0E , &H00 , &H00 , &HF0 , &HF0 )
                               Print "PICTUREEND "
                          End If
                     Wend
                 End If
            End If
            Goto Nextpicture
      End If
    End If
End Sub